// /* eslint-disable */
/************************************************************************************************
*   深圳市摩西尔电子有限公司 @版本所有@
*
*   此文件用于测试 /util/mc_ui_page.js 页面函数
*
* 修改:
*   1. 类型 : 创建
*      作者 : 巫昭雯
*      时间 : 2021.04.19
*      内容 : 所有代码
************************************************************************************************/


/* exported tc_page_param_is_dom_1 */
/* exported tc_page_param_is_dom_2 */
/* exported tc_page_get_val_form_str_arr_1 */
/* exported tc_page_calc_item_size */
/* exported tc_page_util_round */
/* exported tc_page_add_item_prefix */
/* exported tc_page_get_url_page_name */
/* exported tc_page_get_render_color */
/* exported tc_page_add_cssRule */
/* exported tc_page_progress_circle */
/* exported tc_page_pergress_html */
/* exported tc_page_set_style_html */


/* global $ */
/* global mc_util_is_object_dom */
/* global get_val_from_str_arr */
/* global mc_page_calc_item_size */
/* global mc_util_round */
/* global mc_add_item_prefix */
/* global mc_util_get_url_page_name */
/* global mc_random_color */
/* global mc_add_css_rules */
/* global mc_progress_circle */
/* global get_progress_bar_html */
/* global mc_format_style */


var str_error = "返回结果错误";

// 构造多条结果说明
function tc_create_result_info(key, value) {
    return "<p>参数 " + key + " --- 返回值 " + value + "</p>";
}

function tc_page_param_is_dom_1(callback) {
    if (false === mc_util_is_object_dom(null)) {
        callback(1, tc_create_result_info("null", false) );
        return;
    }

    callback(0, str_error);
}


function tc_page_param_is_dom_2(callback) {
    var dom = document.getElementById("tc_dom");

    if (dom) {
        if (mc_util_is_object_dom(dom)) {
            callback(1, tc_create_result_info("id为'tc_dom'的对象", "true"));
            return;
        }

        callback(0, str_error);
    }
}


function tc_page_get_val_form_str_arr_1(callback) {
    var str = "1=MC_LANG_OPTION_STR_1_DSP,3=MC_LANG_OPTION_STR_3_DSP,4=MC_LANG_OPTION_STR_4_DSP";

    if ( "MC_LANG_OPTION_STR_4_DSP" === get_val_from_str_arr(str, "4")) {
        callback(1);
        return;
    }

    callback(0,str_error);
    return;
}


function tc_page_calc_item_size(callback) {
    if ("calc(10% + 5px)" === mc_page_calc_item_size(10, "5px", true)) {
        callback(1);
        return;
    }
    callback(0, str_error);
}

function tc_page_add_item_prefix(callback) {
    if ("1=MC_LANG_1,5=MC_LANG_5" === mc_add_item_prefix("1,,5,","MC_LANG_")) {
        return callback(1);
    }
    return callback(0, str_error);
}


function tc_page_util_round(callback) {
    var obj = {
        "1.5": 1,
        "1.6": 2,
        "1.45": 1,
        "1.51": 2,
        "1.59": 2
    };

    var res = true;
    var msg = "";

    for (var key in obj) {
        if (Object.hasOwnProperty.call(obj, key)) {
            var ret_val = mc_util_round(key);

            msg += tc_create_result_info(key, ret_val);

            if (ret_val !== obj[key]) {
                res = false;
            }
        }
    }

    if (res) {
        return callback(1, msg);
    }

    return callback(0, str_error);
}


function tc_page_get_url_page_name(callback) {
    var obj = {
        "/ci/test_case/index.html": "index.html",
        "/ci/test_case/index": false
    };

    var res = true;
    var msg = "";

    for (var key in obj) {
        if (Object.hasOwnProperty.call(obj, key)) {
            var ret_val = mc_util_get_url_page_name(key);

            msg += tc_create_result_info(key, ret_val);

            if (ret_val !== obj[key]) {
                res = false;
            }
        }
    }

    if (res) {
        return callback(1, msg );
    }

    return callback(0, str_error);
}


function tc_page_get_render_color(callback) {
    var msg = "";

    for (let index = 0; 10 > index; index++) {
        var color = mc_random_color();

        msg += "<p style='width:70px;text-align:center;display: inline-block;margin: 2px;padding:10px;background-color:" + color + ";color:white;' class='tc_rendom_color'>" + color + "</p>";
    }

    return callback(1, msg);
}


function tc_page_add_cssRule(callback) {
    // tc_test_stylesheet
    var tc_test_rule1 = "color:white; background-color:blue";

    if (mc_add_css_rules("tc_test_stylesheet", ".color_blue", tc_test_rule1)) {
        // var msg = "";
        // msg += "<div class='color_blue'>" + tc_create_result_info(tc_test_rule1) + "</div>";
        // var o_stylesheet = document.getElementById("tc_test_stylesheet").cloneNode(true);
        // var o_doc_tc = document.getElementById("tifrem_tc").contentDocument;
        // o_doc_tc.head.append(o_stylesheet);

        return callback(1);
    }

    return callback(0, "参数个数错误 || 样式表不存在");
}


function tc_page_progress_circle(callback) {
    var o_entry = new mc_progress_circle();

    if (o_entry.render_one("tc_canvas_procircle", 2, 50, "#558")) {
        var o_circle = document.getElementById("tc_canvas_procircle");

        $("#tc_dom #tc_circle_container").html("<canvas id='tc_canvas_procircle' width='50px' height='50px'></canvas>");

        return callback(1, o_circle);
    }

    return callback(0);
}


function tc_page_pergress_html(callback) {
    // get_progress_bar_html
    var res = get_progress_bar_html("进度条标题123", 80, "");
    var res_1 = get_progress_bar_html("进度条标题235", 10, "#555");

    if (0 >= res.length) {
        return callback(0, res);
    }

    return callback(1, res + res_1);
}

function tc_page_set_style_html(callback) {
    // mc_format_style;

    var o_style = new mc_format_style();

    o_style.set_val("width", 80);
    o_style.set_val("height", 80);
    o_style.set_val("background-color", "blue", null);
    o_style.set_val("border", "");
    o_style.set_val("color", "white", null);

    var res = "<p style=" + o_style.get_style() + ">样式</p>";

    return callback(1, res);
}
